# 🌸 Admin Panel - Queen Florist

Panel administrasi untuk mengelola agenda Queen Florist dengan fitur CRUD lengkap.

## 🚀 Cara Setup

### 1. Database Setup

1. **Buka phpMyAdmin** (http://localhost/phpmyadmin)
2. **Buat database** bernama `queen_florist`
3. **Import file SQL** `../database.sql`
4. **Pastikan tabel-tabel** terbuat dengan benar:
   - `agenda` - Tabel agenda
   - `admin_users` - Tabel user admin
   - `api_logs` - Tabel log API

### 2. File Configuration

Pastikan struktur folder如下:
```
queen-florist/
├── index.html              # Halaman utama
├── style.css               # Styles utama
├── script.js               # JavaScript utama
├── database.sql            # Database schema
├── mimin/                  # Folder admin
│   ├── index.html          # Halaman admin
│   ├── admin-style.css     # Styles admin
│   ├── admin-script.js     # JavaScript admin
│   └── README.md           # Ini
└── api/                    # Folder API (buat manual)
    ├── config.php          # Konfigurasi database
    ├── agenda.php          # API agenda
    └── auth.php            # API authentication
```

### 3. API Setup

Buat folder `api` dan copy file-file PHP:
1. Buat folder `api` di dalam `queen-florist`
2. Copy file `config.php`, `agenda.php`, `auth.php` ke folder `api`
3. Edit `config.php` jika perlu (username/password database)

## 🔐 Login Admin

**Default Login:**
- **Username:** `admin`
- **Password:** `admin123`

## 📋 Fitur Admin Panel

### ✅ Dashboard
- **Statistics:** Total agenda, agenda aktif, agenda bulan ini
- **Real-time updates** otomatis
- **Responsive design** untuk mobile & desktop

### ✅ Manajemen Agenda
- **Create:** Tambah agenda baru
- **Read:** Lihat semua agenda dengan filter
- **Update:** Edit agenda yang ada
- **Delete:** Hapus agenda dengan konfirmasi

### ✅ Fitur Search & Filter
- **Search:** Cari agenda berdasarkan judul/deskripsi
- **Filter by Month:** Filter agenda per bulan
- **Real-time filtering:** Hasil langsung muncul

### ✅ Form Validation
- **Required fields:** Tanggal, bulan, judul wajib diisi
- **Date validation:** Tanggal 1-31, bulan 1-12
- **Duplicate check:** Cegah agenda ganda di tanggal yang sama

### ✅ User Experience
- **Loading states:** Indikator loading saat proses
- **Toast notifications:** Notifikasi sukses/error
- **Modal dialogs:** Form dalam modal yang elegan
- **Keyboard shortcuts:** Ctrl+N untuk tambah, ESC untuk tutup modal

## 🛠️ API Endpoints

### Get All Agendas
```
GET /api/agenda.php
```

### Get Agenda by Month
```
GET /api/agenda.php?month=10
```

### Search Agenda
```
GET /api/agenda.php?search=Hari
```

### Create Agenda
```
POST /api/agenda.php
Content-Type: application/json
Authorization: Bearer {token}

{
  "month": 10,
  "day": 28,
  "title": "Hari Sumpah Pemuda",
  "description": "Memperingati ikrar pemuda Indonesia",
  "is_active": 1
}
```

### Update Agenda
```
PUT /api/agenda.php
Content-Type: application/json
Authorization: Bearer {token}

{
  "id": 1,
  "title": "Judul Baru",
  "description": "Deskripsi baru"
}
```

### Delete Agenda
```
DELETE /api/agenda.php?id=1
Authorization: Bearer {token}
```

### Login
```
POST /api/auth.php
Content-Type: application/json

{
  "username": "admin",
  "password": "admin123"
}
```

## 📊 Database Schema

### Table: agenda
```sql
CREATE TABLE agenda (
    id INT AUTO_INCREMENT PRIMARY KEY,
    month INT NOT NULL,
    day INT NOT NULL,
    title VARCHAR(255) NOT NULL,
    description TEXT,
    is_active TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);
```

### Table: admin_users
```sql
CREATE TABLE admin_users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    email VARCHAR(100),
    full_name VARCHAR(100),
    is_active TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
```

## 🔧 Troubleshooting

### Database Connection Error
1. Pastikan MySQL server running di XAMPP
2. Check database name `queen_florist`
3. Verify username/password di `config.php`

### API Not Working
1. Pastikan PHP file ada di folder `api`
2. Check file permissions
3. Enable error reporting: `error_reporting(E_ALL);`

### Login Failed
1. Check database table `admin_users`
2. Verify password hashing
3. Clear browser cache/localStorage

### Agenda Not Loading
1. Check browser console untuk error
2. Verify API endpoint accessible
3. Check database connection

## 🌐 Browser Support

- ✅ Chrome 60+
- ✅ Firefox 55+
- ✅ Safari 12+
- ✅ Edge 79+

## 📱 Mobile Responsive

Admin panel fully responsive:
- **Mobile (< 768px):** Single column, touch-friendly
- **Tablet (768px-1024px):** Optimized layout
- **Desktop (> 1024px):** Full features

## 🔒 Security Features

- **Token authentication** untuk API access
- **Input validation** dan sanitization
- **SQL injection prevention** dengan prepared statements
- **CORS headers** untuk cross-origin requests
- **API logging** untuk monitoring

## 🚀 Performance

- **Lazy loading** untuk data
- **Debounced search** untuk efficiency
- **Optimized queries** dengan indexes
- **Minimal DOM manipulation**
- **Efficient event handling**

---

**🌸 Queen Florist Admin Panel**  
*Modern CRUD system for agenda management*